@ vim: set ft=armv4 noet:

#define RGB(r,g,b) (r|(g<<5)|(b<<10))

.arch armv4
.cpu  arm7tdmi

.section .text.crt0,"ax",%progbits

.arm

.type _start,%function
.globl _start
_start:
	b main

.thumb
.thumb_func
payload:
	mov  r3, r1

	@ set display mode
	ldr  r0, dispcntval
	mov  r5, #5
	strh r0, [r4] @ DISPCNT @ this one's very dark, so I'm putting it in a place where it's not visible for long
	lsl  r5, #24
	lsr  r0, #16
	strh r0, [r4,#0x0C] @ BG2CNT

	@ldr r5, =0x05000000 @ CGRAM
	mov  r0, #0x5f
	strh r0, [r5,#2]
	@bl  newcol

	@ unpack graphics into VRAM
	@ldr r0, =graphics
	add r0, pc, #(graphics-.Lnextin0)
.Lnextin0:
	mov r1, r7
	@ldr r2, =unpackdata
	add r2, pc, #(unpackdata-.Lnextin1)
.Lnextin1:
	swi 0x10

	@ set up the tilemap
	mov  r6, #0x80
	lsl  r6, #4
	add  r6, r7
	ldr  r0, =0x04030201
	strh r0, [r6]
	lsr  r0, #16
	strh r0, [r6,#0x10]

	mov r1, #0 @ x
	mov r2, #0 @ y
	@ r3 == WRAM
	@ r4 == MMIO
	@ r5 == CGRAM
	mov r6, #1
	neg r7, r6 @ dy
	neg r6, r6 @ dx

.thumb_func
mainloop:
	@ wait for vbl
	ldrh r0, [r4, #6]
	cmp r0, #160
	bge mainloop
	ldrh r0, [r4, #6]
	cmp r0, #160
	blt mainloop

	add r1, r6
	bne .Lnobackx
	neg r6, r6
	bl newcol
.Lnobackx:
	add r2, r7
	bne .Lnobacky
	neg r7, r7
	bl newcol
.Lnobacky:

	mov r0, #(240-11)
	neg r0, r0
	cmp r1, r0
	bgt .Lnoflipx
	neg r6, r6
	bl newcol
.Lnoflipx:
	mov r0, #(160-15)
	neg r0, r0
	cmp r2, r0
	bgt .Lnoflipy
	neg r7, r7
	bl newcol
.Lnoflipy:

	lsl r1, #8
	lsl r2, #8
	str r1, [r4, #0x28]
	str r2, [r4, #0x2C]
	asr r1, #8
	asr r2, #8

	b mainloop

.type graphics,%object
graphics:
	@ tile 0 (xxxh -> 000h)
	.8byte 0
@	@ tile 1 (800h -> 040h) : TOP LEFT
@	.byte 0b11111111
@	.byte 0b00000001
@	.byte 0b11000001
@	.byte 0b00001101
@	.byte 0b11000001
@	.byte 0b00001101
@	.byte 0b11000001
@	.byte 0b00000001
@	@ tile 2 (801h -> 080h) : TOP RIGHT
@	.byte 0b00000111
@	.byte 0b00000100
@	.byte 0b00000100
@	.byte 0b00000101
@	.byte 0b00000100
@	.byte 0b00000101
@	.byte 0b00000100
@	.byte 0b00000100
	@ tile 1 (800h -> 040h) : TOP LEFT
	.byte 0b11111111
	.byte 0b00000001
	.byte 0b11000101
	.byte 0b00100101
	.byte 0b00100101
	.byte 0b00100101
	.byte 0b11011101
	.byte 0b00000001
	@ tile 2 (801h -> 080h) : TOP RIGHT
	.byte 0b01111111
	.byte 0b01000000
	.byte 0b01000100
	.byte 0b01000101
	.byte 0b01000101
	.byte 0b01000101
	.byte 0b01011100
	.byte 0b01000000
	@ tile 3, 4 (810h -> 0C0h, 811h -> 100h) : BOTTOM LEFT, RIGHT
	.byte 0xFF,0,0,0,0,0,0,0
	.byte 0x7F,0,0,0,0,0,0,0
graphics_end:

	.thumb
	.thumb_func
.type newcol,%function
newcol:
	ldrh r0, [r3]
	strh r0, [r5, #2]
	add  r3, #2

	@ loop the colors
	mov r0, #3
	lsl r0, #24
	.byte 0x96, 0x36 @ adds r6, #0x96 @ magic byte!
	add r0, #0x7f
	and r3, r0
	sub r6, #0x96

	bx  lr

.arm
.type main,%function
.globl main
main:
	mov r7, #0x03000000
	mov r4, #0x04000000
	add r1, pc, #(payload-.Lnextins-4)
.Lnextins:
	add r0, pc, #5
	mov r2, #((payload_end - payload) >> 2)
	bx  r0

.thumb
.thumb_func
.type main$thumb,%function
main$thumb:
	mov r0, r1
	mov r1, r7
	swi 0x0C
	mov r1, r7
	lsl r7, #1
	mov r4, #0x40
	lsl r4, #20
	mov pc, r1

.type dispcntval,%object
dispcntval:
	.2byte 2 | (1<<10) @ mode 2, enable bg2 only
.type bg2cntval,%object
bg2cntval:
	.2byte (1<<7) | (1<<8) @ 256color, map base 1

.pool

.type unpackdata,%object
unpackdata:
	.2byte graphics_end-graphics @ data length
	.byte  1 @ 2 color input
	.byte  8 @ 256 color output
	.4byte 0
.globl payload_end
payload_end:
	.asciz "poro/K2^TTN"

